(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20809,        783]*)
(*NotebookOutlinePosition[     21740,        814]*)
(*  CellTagsIndexPosition[     21696,        810]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Constant Coefficients Vector Systems:\n",
  StyleBox["Homogeneous Case",
    FontSize->14],
  ""
}], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "We now undertake the solution of first order constant coefficient vector \
systems of the form ",
  StyleBox["Y'[x]-A.Y[x]==0",
    FontWeight->"Bold"],
  ".  Here ",
  StyleBox["Y[x]",
    FontWeight->"Bold"],
  " is an n-vector, and  ",
  StyleBox["A",
    FontWeight->"Bold"],
  " is a constant nXn matrix. We want our solution to be defined on some \
interval ",
  StyleBox["I: [a, b]",
    FontWeight->"Bold"],
  " of the reals. The critical ideas are:\n\[Bullet]  matrix ",
  StyleBox["characteristic value problems,",
    FontVariations->{"Underline"->True}],
  " and\n\[Bullet]  ",
  StyleBox["Fundamental sets",
    FontVariations->{"Underline"->True}],
  " of vectors of functions.\nWhen the matrix  A  admits a complete system of \
characteristic vectors (A is diagonalizable), our theory is made simple.  We \
can use the built-in function ",
  StyleBox["Eigensystem",
    FontWeight->"Bold"],
  " (note no inter-capitals!). This we proceed to do. ",
  StyleBox["The next notebook is concerned with the nonhomogeneous case",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The Theory"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  " We solve the homogeneous equation",
  StyleBox["L[Y][x]=",
    FontWeight->"Bold"],
  " ",
  StyleBox["Y'[x]-A.Y[x]==0",
    FontWeight->"Bold"],
  ". \n\[Bullet]  To do this, note that ",
  StyleBox["Y[x]=Exp[r*x]*K",
    FontWeight->"Bold"],
  ", where ",
  StyleBox["K",
    FontWeight->"Bold"],
  " is a constant vector and Exp[x] is the ordinary exponential of the \
variable x, is transformed into ",
  StyleBox["(I*r-A).K==0.",
    FontWeight->"Bold"],
  " This is zero for some nonzero vector(s) K if and only if ",
  StyleBox["Det[A-r*I]==0. ",
    FontWeight->"Bold"],
  "This should be easily identifiable as the same sequence of events we went \
through when solving ",
  StyleBox["characteristic value problems",
    FontVariations->{"Underline"->True}],
  " in the notebooks on Linear Algebra. It is, in fact, the same problem! \n\
\[Bullet]  We suppose that there are n characteristic roots, r1, r2, ..., rn \
which correspond to (linearly independent) nonzero characteristic vectors ",
  StyleBox["K1, K2, ..., Kn",
    FontWeight->"Bold"],
  ". Then these vector functions are all solutions: ",
  StyleBox[
  "Y1[x]=Exp[r1*x]*K1, Y2[x]=Exp[r2*x]*K2, ..., Yn[x]=Exp[rn*x]*Kn.",
    FontWeight->"Bold"],
  "  \n\[Bullet]  The matrix ",
  StyleBox["W[x, Y1,...,Yn]",
    FontWeight->"Bold"],
  " having ",
  StyleBox["Y1[x], Y2[x], ..., Yn[x]",
    FontWeight->"Bold"],
  " as columns is the analogue of the Wronskian matrix we saw before, and its \
determinant is nonzero (for any x in I).\n\[Bullet]  ",
  StyleBox["The solution",
    FontVariations->{"Underline"->True}],
  " we desire is ",
  StyleBox["Y[x]=W[x, Y1,...,Yn].C",
    FontWeight->"Bold"],
  ", where ",
  StyleBox["C",
    FontWeight->"Bold"],
  " is an arbitrary constant vector.  Proof: \n",
  StyleBox[
  "L[Y][x]=={L[Y1][x], L[Y2][x], ..., L[Yn][x]}.C=={0, 0, ..., 0}.C==0\n",
    FontWeight->"Bold"],
  "for any choice of ",
  StyleBox["C",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["How to Do It"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData[
"The Characteristic Equation for Matrix A has Distinct Real Roots"], 
  "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Solve ",
  StyleBox["Y'[x]-A.Y[x]==0",
    FontWeight->"Bold"],
  ", where:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = {{\(-1\), 1}, {2, 0}}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-1\), 1}, {2, 0}}\)], "Output"]
}, Closed]],

Cell[TextData["Solve the characteristic value problem for A:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({roots, vectors} = Eigensystem[A]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-2\), 1}, {{\(-1\), 1}, {1, 2}}}\)], "Output"]
}, Closed]],

Cell[TextData["Here are the exponentials needed:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(exponentials = \((Exp[#1\ x] &)\)[roots]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(\(-2\)\ x\), \[ExponentialE]\^x}\)], "Output"]
}, Closed]],

Cell[TextData["The Fundamental (Wronskian) matrix of the system is:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(W[x_] = Transpose[vectors\ exponentials]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-\[ExponentialE]\^\(\(-2\)\ x\)\), \[ExponentialE]\^x}, {\
\[ExponentialE]\^\(\(-2\)\ x\), 2\ \[ExponentialE]\^x}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["W", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "-", \(A . W[x]\)}], 
      "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{0, 0}, {0, 0}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The matrix ",
  StyleBox["vectors",
    FontWeight->"Bold"],
  " has its results listed as rows, not columns; * multiplies  corresponding \
entries, but does not sum as Dot would (so we still have a square matrix, \
rather than a vector); and the second transpose gives us the proper form: our \
solution vectors are now the columns."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Given any constant vector ",
  StyleBox["{K1,K2},",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " the solution is:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Y[x_] = W[x] . {K1, K2}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(-\[ExponentialE]\^\(\(-2\)\ x\)\)\ K1 + \[ExponentialE]\^x\ K2, \
\[ExponentialE]\^\(\(-2\)\ x\)\ K1 + 2\ \[ExponentialE]\^x\ K2}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "... so that dotting by the (column) vector ",
  StyleBox["{K1,K2}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " forms the correct linear combination of columns (solution vectors)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["The given solution vector checks:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["Y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "-", \(A . Y[x]\)}], 
      "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({0, 0}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"The Characteristic Equation for Matrix A has Complex Roots"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Solve ",
  StyleBox["Y'[x]-A.Y[x]==0",
    FontWeight->"Bold"],
  ", where:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = {{1, \(-2\)}, {5, \(-1\)}}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{1, \(-2\)}, {5, \(-1\)}}\)], "Output"]
}, Closed]],

Cell[TextData["Solve the characteristic value problem for A:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({roots, vectors} = Eigensystem[A]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-3\)\ \[ImaginaryI], 
        3\ \[ImaginaryI]}, {{1 - 3\ \[ImaginaryI], 5}, {1 + 3\ \[ImaginaryI], 
          5}}}\)], "Output"]
}, Closed]],

Cell[TextData["Verify these results:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(A . Transpose[vectors] == 
      Transpose[vectors] . DiagonalMatrix[roots]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData["Here are the exponentials needed:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(exponentials = \((Exp[#1\ x] &)\)[roots]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ x\), \[ExponentialE]\^\(3\ \
\[ImaginaryI]\ x\)}\)], "Output"]
}, Closed]],

Cell[TextData["The Fundamental (Wronskian) matrix of the system is:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(W[x_] = Transpose[vectors\ exponentials]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\((1 - 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ \
x\), \((1 + 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)}, \
{5\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ x\), 
        5\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)}}\)], "Output"]
}, Closed]],

Cell[TextData["Our solution vectors are now the columns."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"The Wronskian matrix satisfies the homogeneous (matrix) equation:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["W", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "-", \(A . W[x]\)}], 
      "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{0, 0}, {0, 0}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Given any constant vector ",
  StyleBox["{K1,K2},",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " the vector solution is:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Y[x_] = W[x] . {K1, K2}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\((1 - 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ \
x\)\ K1 + \((1 + 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)\ \
K2, 5\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ x\)\ K1 + 
        5\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)\ K2}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "... Dotting by the (column) vector ",
  StyleBox["{K1,K2}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " forms the correct linear combination of columns (fundamental solution \
vectors)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["The given solution vector checks:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["Y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "-", \(A . Y[x]\)}], 
      "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({0, 0}\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Automating the Process"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "This is a simplistic approach to the problem because it does not address \
the  problem of degenerate matrices: those nXn matrices whose system of \
eigenvalues is not a basis for n-space.  However, for diagonalizable \
matrices, this function does work. ",
  StyleBox["It returns the fundamental matrix",
    FontVariations->{"Underline"->True}],
  ", from which vector solutions can easily be obtained."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(FundamentalMatrix[A_, x_] := 
      Block[{roots, vectors, exponentials}, {roots, vectors} = 
          Eigensystem[A]; exponentials = \((Exp[#1\ x] &)\)[roots]; 
        Transpose[vectors\ exponentials]]\)], "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["The two examples above:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Y[x_] = 
      FundamentalMatrix[{{\(-1\), 1}, {2, 0}}, x] . {K1, K2}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(-\[ExponentialE]\^\(\(-2\)\ x\)\)\ K1 + \[ExponentialE]\^x\ K2, \
\[ExponentialE]\^\(\(-2\)\ x\)\ K1 + 2\ \[ExponentialE]\^x\ K2}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["Y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], 
        "-", \({{\(-1\), 1}, {2, 0}} . Y[x]\)}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({0, 0}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Y[x_] = 
      FundamentalMatrix[{{1, \(-2\)}, {5, \(-1\)}}, x] . {K1, K2}\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    \({\((1 - 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ \
x\)\ K1 + \((1 + 
              3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)\ \
K2, 5\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ x\)\ K1 + 
        5\ \[ExponentialE]\^\(3\ \[ImaginaryI]\ x\)\ K2}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["Y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], 
        "-", \({{1, \(-2\)}, {5, \(-1\)}} . Y[x]\)}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({0, 0}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["For further thought"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"What is the best form for a solution which corresponds to a conjugate pair \
of complex roots?  Consider the first column of the fundamental matrix above \
which had complex roots:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["An investigation"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(column = \(Transpose[
          FundamentalMatrix[{{1, \(-2\)}, {5, \(-1\)}}, 
            x]]\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(column\)\" is similar \
to existing symbol \"\!\(Column\)\"."\)], "Message"],

Cell[BoxData[
    \({\((1 - 
            3\ \[ImaginaryI])\)\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ \
x\), 5\ \[ExponentialE]\^\(\(-3\)\ \[ImaginaryI]\ x\)}\)], "Output"]
}, Closed]],

Cell[TextData[
"Let's convert this to a pair of real solutions. To this end, declare x to be \
real:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(x /: Re[x] = x\), "\n", 
    \(\(x /: Im[x] = 0;\)\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Now, consider this fundamental matrix which we obtain from ",
  StyleBox["column",
    FontWeight->"Bold"],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(W[x_] = Transpose[{Re[column], Im[column]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{Cos[3\ x] - 3\ Sin[3\ x], \(-3\)\ Cos[3\ x] - 
          Sin[3\ x]}, {5\ Cos[3\ x], \(-5\)\ Sin[3\ x]}}\)], "Output"]
}, Closed]],

Cell[TextData[
"(The transpose is necessary to restore the columns.) This is still a \
solution to the matrix equation:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["W", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], 
        "-", \({{1, \(-2\)}, {5, \(-1\)}} . W[x]\)}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{0, 0}, {0, 0}}\)], "Output"]
}, Closed]],

Cell[TextData[
"Note that the entries in this solution are real.  This is a more familiar \
form for the solution. It is not the simplest form, however. Consider this:"],
   "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((W1[x_] = Simplify[W[x] . Inverse[W[0]]])\) // MatrixForm\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(Cos[3\ x] + 1\/3\ Sin[3\ x]\), \(\(-\(2\/3\)\)\ Sin[3\ x]\)},
            {\(5\/3\ Sin[3\ x]\), \(Cos[3\ x] - 1\/3\ Sin[3\ x]\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[TextData["Here is the initial value of W1:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(W1[0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{1, 0}, {0, 1}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["W1", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], 
        "-", \({{1, \(-2\)}, {5, \(-1\)}} . W1[x]\)}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{0, 0}, {0, 0}}\)], "Output"]
}, Closed]],

Cell[TextData["Note that W1 (and hence W) is fundamental:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[W1[x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(Cos[3\ x]\^2 + Sin[3\ x]\^2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Two questions"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "\[Bullet]  How could the ",
  StyleBox["FundamentalMatrix",
    FontWeight->"Bold"],
  " function be modified to return all solutions in their real (rather than \
complex) form?\n\[Bullet]  What can be done about deficient matrices (where a \
complete set of characteristic vectors does not exist)? This leads into the \
study of the Jordan Canonical Form for a matrix."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Initialization"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Needs["\<Algebra`ReIm`\>"]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{522, 564},
WindowMargins->{{68, Automatic}, {Automatic, 25}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 180, 7, 95, "Subtitle",
  Evaluatable->False],
Cell[1959, 62, 1148, 32, 158, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3132, 98, 88, 2, 56, "Section",
  Evaluatable->False],
Cell[3223, 102, 2039, 59, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[5299, 166, 90, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5414, 172, 149, 4, 46, "Subsection",
  Evaluatable->False],
Cell[5566, 178, 156, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5747, 189, 85, 2, 27, "Input"],
Cell[5835, 193, 55, 1, 27, "Output"]
}, Closed]],
Cell[5905, 197, 120, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6050, 203, 93, 2, 27, "Input"],
Cell[6146, 207, 70, 1, 27, "Output"]
}, Closed]],
Cell[6231, 211, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6364, 217, 100, 2, 27, "Input"],
Cell[6467, 221, 86, 1, 29, "Output"]
}, Closed]],
Cell[6568, 225, 127, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6720, 231, 100, 2, 27, "Input"],
Cell[6823, 235, 152, 2, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7012, 242, 244, 7, 27, "Input"],
Cell[7259, 251, 50, 1, 27, "Output"]
}, Closed]],
Cell[7324, 255, 414, 10, 68, "Text",
  Evaluatable->False],
Cell[7741, 267, 205, 8, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7971, 279, 83, 2, 27, "Input"],
Cell[8057, 283, 166, 2, 29, "Output"]
}, Closed]],
Cell[8238, 288, 272, 8, 50, "Text",
  Evaluatable->False],
Cell[8513, 298, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8646, 304, 244, 7, 27, "Input"],
Cell[8893, 313, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8982, 320, 140, 3, 46, "Subsection",
  Evaluatable->False],
Cell[9125, 325, 156, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9306, 336, 90, 2, 27, "Input"],
Cell[9399, 340, 60, 1, 27, "Output"]
}, Closed]],
Cell[9474, 344, 120, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9619, 350, 93, 2, 27, "Input"],
Cell[9715, 354, 153, 3, 27, "Output"]
}, Closed]],
Cell[9883, 360, 96, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10004, 366, 135, 3, 43, "Input"],
Cell[10142, 371, 38, 1, 27, "Output"]
}, Closed]],
Cell[10195, 375, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10328, 381, 100, 2, 27, "Input"],
Cell[10431, 385, 125, 2, 32, "Output"]
}, Closed]],
Cell[10571, 390, 127, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10723, 396, 100, 2, 27, "Input"],
Cell[10826, 400, 321, 6, 32, "Output"]
}, Closed]],
Cell[11162, 409, 116, 2, 32, "Text",
  Evaluatable->False],
Cell[11281, 413, 141, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11447, 420, 244, 7, 27, "Input"],
Cell[11694, 429, 50, 1, 27, "Output"]
}, Closed]],
Cell[11759, 433, 212, 8, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11996, 445, 83, 2, 27, "Input"],
Cell[12082, 449, 335, 6, 32, "Output"]
}, Closed]],
Cell[12432, 458, 278, 9, 50, "Text",
  Evaluatable->False],
Cell[12713, 469, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12846, 475, 244, 7, 27, "Input"],
Cell[13093, 484, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13194, 492, 100, 2, 36, "Section",
  Evaluatable->False],
Cell[13297, 496, 485, 10, 86, "Text",
  Evaluatable->False],
Cell[13785, 508, 264, 5, 91, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[14086, 518, 86, 2, 36, "Section",
  Evaluatable->False],
Cell[14175, 522, 98, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14298, 528, 129, 3, 27, "Input"],
Cell[14430, 533, 166, 2, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14633, 540, 266, 7, 27, "Input"],
Cell[14902, 549, 40, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14979, 555, 136, 4, 27, "Input"],
Cell[15118, 561, 335, 6, 32, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15490, 572, 271, 7, 27, "Input"],
Cell[15764, 581, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15853, 588, 97, 2, 36, "Section",
  Evaluatable->False],
Cell[15953, 592, 256, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16234, 601, 97, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16356, 607, 198, 4, 59, "Input"],
Cell[16557, 613, 185, 3, 49, "Message"],
Cell[16745, 618, 174, 3, 32, "Output"]
}, Closed]],
Cell[16934, 624, 160, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17119, 632, 112, 3, 43, "Input"],
Cell[17234, 637, 35, 1, 27, "Output"]
}, Closed]],
Cell[17284, 641, 193, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17502, 652, 103, 2, 27, "Input"],
Cell[17608, 656, 139, 2, 43, "Output"]
}, Closed]],
Cell[17762, 661, 179, 4, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17966, 669, 271, 7, 27, "Input"],
Cell[18240, 678, 50, 1, 27, "Output"]
}, Closed]],
Cell[18305, 682, 230, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18560, 691, 121, 3, 27, "Input"],
Cell[18684, 696, 324, 7, 71, "Output"]
}, Closed]],
Cell[19023, 706, 107, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19155, 712, 65, 2, 27, "Input"],
Cell[19223, 716, 50, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[19310, 722, 273, 7, 27, "Input"],
Cell[19586, 731, 50, 1, 27, "Output"]
}, Closed]],
Cell[19651, 735, 117, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19793, 741, 70, 2, 27, "Input"],
Cell[19866, 745, 61, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19976, 752, 94, 2, 46, "Subsection",
  Evaluatable->False],
Cell[20073, 756, 450, 10, 70, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20572, 772, 92, 2, 36, "Section",
  Evaluatable->False],
Cell[20667, 776, 114, 3, 27, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

